/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */

import {
  ethers,
  EventFilter,
  Signer,
  BigNumber,
  BigNumberish,
  PopulatedTransaction,
} from "ethers";
import {
  Contract,
  ContractTransaction,
  Overrides,
  CallOverrides,
} from "@ethersproject/contracts";
import { BytesLike } from "@ethersproject/bytes";
import { Listener, Provider } from "@ethersproject/providers";
import { FunctionFragment, EventFragment, Result } from "@ethersproject/abi";

interface IUniswapV3PoolInterface extends ethers.utils.Interface {
  functions: {
    "burn(int24,int24,uint128)": FunctionFragment;
    "collect(address,int24,int24,uint128,uint128)": FunctionFragment;
    "collectProtocol(address,uint128,uint128)": FunctionFragment;
    "factory()": FunctionFragment;
    "fee()": FunctionFragment;
    "feeGrowthGlobal0X128()": FunctionFragment;
    "feeGrowthGlobal1X128()": FunctionFragment;
    "flash(address,uint256,uint256,bytes)": FunctionFragment;
    "increaseObservationCardinalityNext(uint16)": FunctionFragment;
    "initialize(uint160)": FunctionFragment;
    "liquidity()": FunctionFragment;
    "maxLiquidityPerTick()": FunctionFragment;
    "mint(address,int24,int24,uint128,bytes)": FunctionFragment;
    "observations(uint256)": FunctionFragment;
    "observe(uint32[])": FunctionFragment;
    "positions(bytes32)": FunctionFragment;
    "protocolFees()": FunctionFragment;
    "setFeeProtocol(uint8,uint8)": FunctionFragment;
    "slot0()": FunctionFragment;
    "snapshotCumulativesInside(int24,int24)": FunctionFragment;
    "swap(address,bool,int256,uint160,bytes)": FunctionFragment;
    "tickBitmap(int16)": FunctionFragment;
    "tickSpacing()": FunctionFragment;
    "ticks(int24)": FunctionFragment;
    "token0()": FunctionFragment;
    "token1()": FunctionFragment;
  };

  encodeFunctionData(
    functionFragment: "burn",
    values: [BigNumberish, BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "collect",
    values: [string, BigNumberish, BigNumberish, BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "collectProtocol",
    values: [string, BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(functionFragment: "factory", values?: undefined): string;
  encodeFunctionData(functionFragment: "fee", values?: undefined): string;
  encodeFunctionData(
    functionFragment: "feeGrowthGlobal0X128",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "feeGrowthGlobal1X128",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "flash",
    values: [string, BigNumberish, BigNumberish, BytesLike]
  ): string;
  encodeFunctionData(
    functionFragment: "increaseObservationCardinalityNext",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "initialize",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(functionFragment: "liquidity", values?: undefined): string;
  encodeFunctionData(
    functionFragment: "maxLiquidityPerTick",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "mint",
    values: [string, BigNumberish, BigNumberish, BigNumberish, BytesLike]
  ): string;
  encodeFunctionData(
    functionFragment: "observations",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "observe",
    values: [BigNumberish[]]
  ): string;
  encodeFunctionData(
    functionFragment: "positions",
    values: [BytesLike]
  ): string;
  encodeFunctionData(
    functionFragment: "protocolFees",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "setFeeProtocol",
    values: [BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(functionFragment: "slot0", values?: undefined): string;
  encodeFunctionData(
    functionFragment: "snapshotCumulativesInside",
    values: [BigNumberish, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "swap",
    values: [string, boolean, BigNumberish, BigNumberish, BytesLike]
  ): string;
  encodeFunctionData(
    functionFragment: "tickBitmap",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "tickSpacing",
    values?: undefined
  ): string;
  encodeFunctionData(functionFragment: "ticks", values: [BigNumberish]): string;
  encodeFunctionData(functionFragment: "token0", values?: undefined): string;
  encodeFunctionData(functionFragment: "token1", values?: undefined): string;

  decodeFunctionResult(functionFragment: "burn", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "collect", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "collectProtocol",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "factory", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "fee", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "feeGrowthGlobal0X128",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "feeGrowthGlobal1X128",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "flash", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "increaseObservationCardinalityNext",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "initialize", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "liquidity", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "maxLiquidityPerTick",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "mint", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "observations",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "observe", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "positions", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "protocolFees",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "setFeeProtocol",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "slot0", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "snapshotCumulativesInside",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "swap", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "tickBitmap", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "tickSpacing",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "ticks", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "token0", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "token1", data: BytesLike): Result;

  events: {
    "Burn(address,int24,int24,uint128,uint256,uint256)": EventFragment;
    "Collect(address,address,int24,int24,uint128,uint128)": EventFragment;
    "CollectProtocol(address,address,uint128,uint128)": EventFragment;
    "Flash(address,address,uint256,uint256,uint256,uint256)": EventFragment;
    "IncreaseObservationCardinalityNext(uint16,uint16)": EventFragment;
    "Initialize(uint160,int24)": EventFragment;
    "Mint(address,address,int24,int24,uint128,uint256,uint256)": EventFragment;
    "SetFeeProtocol(uint8,uint8,uint8,uint8)": EventFragment;
    "Swap(address,address,int256,int256,uint160,uint128,int24)": EventFragment;
  };

  getEvent(nameOrSignatureOrTopic: "Burn"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Collect"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "CollectProtocol"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Flash"): EventFragment;
  getEvent(
    nameOrSignatureOrTopic: "IncreaseObservationCardinalityNext"
  ): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Initialize"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Mint"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "SetFeeProtocol"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Swap"): EventFragment;
}

export class IUniswapV3Pool extends Contract {
  connect(signerOrProvider: Signer | Provider | string): this;
  attach(addressOrName: string): this;
  deployed(): Promise<this>;

  on(event: EventFilter | string, listener: Listener): this;
  once(event: EventFilter | string, listener: Listener): this;
  addListener(eventName: EventFilter | string, listener: Listener): this;
  removeAllListeners(eventName: EventFilter | string): this;
  removeListener(eventName: any, listener: Listener): this;

  interface: IUniswapV3PoolInterface;

  functions: {
    burn(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "burn(int24,int24,uint128)"(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    collect(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "collect(address,int24,int24,uint128,uint128)"(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    collectProtocol(
      recipient: string,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "collectProtocol(address,uint128,uint128)"(
      recipient: string,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    factory(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "factory()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    fee(overrides?: CallOverrides): Promise<{
      0: number;
    }>;

    "fee()"(overrides?: CallOverrides): Promise<{
      0: number;
    }>;

    feeGrowthGlobal0X128(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    "feeGrowthGlobal0X128()"(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    feeGrowthGlobal1X128(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    "feeGrowthGlobal1X128()"(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    flash(
      recipient: string,
      amount0: BigNumberish,
      amount1: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "flash(address,uint256,uint256,bytes)"(
      recipient: string,
      amount0: BigNumberish,
      amount1: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    increaseObservationCardinalityNext(
      observationCardinalityNext: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "increaseObservationCardinalityNext(uint16)"(
      observationCardinalityNext: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    initialize(
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "initialize(uint160)"(
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    liquidity(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    "liquidity()"(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    maxLiquidityPerTick(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    "maxLiquidityPerTick()"(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    mint(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "mint(address,int24,int24,uint128,bytes)"(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    observations(
      index: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      blockTimestamp: number;
      tickCumulative: BigNumber;
      secondsPerLiquidityCumulativeX128: BigNumber;
      initialized: boolean;
      0: number;
      1: BigNumber;
      2: BigNumber;
      3: boolean;
    }>;

    "observations(uint256)"(
      index: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      blockTimestamp: number;
      tickCumulative: BigNumber;
      secondsPerLiquidityCumulativeX128: BigNumber;
      initialized: boolean;
      0: number;
      1: BigNumber;
      2: BigNumber;
      3: boolean;
    }>;

    observe(
      secondsAgos: BigNumberish[],
      overrides?: CallOverrides
    ): Promise<{
      tickCumulatives: BigNumber[];
      secondsPerLiquidityCumulativeX128s: BigNumber[];
      0: BigNumber[];
      1: BigNumber[];
    }>;

    "observe(uint32[])"(
      secondsAgos: BigNumberish[],
      overrides?: CallOverrides
    ): Promise<{
      tickCumulatives: BigNumber[];
      secondsPerLiquidityCumulativeX128s: BigNumber[];
      0: BigNumber[];
      1: BigNumber[];
    }>;

    positions(
      key: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      _liquidity: BigNumber;
      feeGrowthInside0LastX128: BigNumber;
      feeGrowthInside1LastX128: BigNumber;
      tokensOwed0: BigNumber;
      tokensOwed1: BigNumber;
      0: BigNumber;
      1: BigNumber;
      2: BigNumber;
      3: BigNumber;
      4: BigNumber;
    }>;

    "positions(bytes32)"(
      key: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      _liquidity: BigNumber;
      feeGrowthInside0LastX128: BigNumber;
      feeGrowthInside1LastX128: BigNumber;
      tokensOwed0: BigNumber;
      tokensOwed1: BigNumber;
      0: BigNumber;
      1: BigNumber;
      2: BigNumber;
      3: BigNumber;
      4: BigNumber;
    }>;

    protocolFees(overrides?: CallOverrides): Promise<{
      token0: BigNumber;
      token1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    "protocolFees()"(overrides?: CallOverrides): Promise<{
      token0: BigNumber;
      token1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    setFeeProtocol(
      feeProtocol0: BigNumberish,
      feeProtocol1: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "setFeeProtocol(uint8,uint8)"(
      feeProtocol0: BigNumberish,
      feeProtocol1: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    slot0(overrides?: CallOverrides): Promise<{
      sqrtPriceX96: BigNumber;
      tick: number;
      observationIndex: number;
      observationCardinality: number;
      observationCardinalityNext: number;
      feeProtocol: number;
      unlocked: boolean;
      0: BigNumber;
      1: number;
      2: number;
      3: number;
      4: number;
      5: number;
      6: boolean;
    }>;

    "slot0()"(overrides?: CallOverrides): Promise<{
      sqrtPriceX96: BigNumber;
      tick: number;
      observationIndex: number;
      observationCardinality: number;
      observationCardinalityNext: number;
      feeProtocol: number;
      unlocked: boolean;
      0: BigNumber;
      1: number;
      2: number;
      3: number;
      4: number;
      5: number;
      6: boolean;
    }>;

    snapshotCumulativesInside(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      tickCumulativeInside: BigNumber;
      secondsPerLiquidityInsideX128: BigNumber;
      secondsInside: number;
      0: BigNumber;
      1: BigNumber;
      2: number;
    }>;

    "snapshotCumulativesInside(int24,int24)"(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      tickCumulativeInside: BigNumber;
      secondsPerLiquidityInsideX128: BigNumber;
      secondsInside: number;
      0: BigNumber;
      1: BigNumber;
      2: number;
    }>;

    swap(
      recipient: string,
      zeroForOne: boolean,
      amountSpecified: BigNumberish,
      sqrtPriceLimitX96: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "swap(address,bool,int256,uint160,bytes)"(
      recipient: string,
      zeroForOne: boolean,
      amountSpecified: BigNumberish,
      sqrtPriceLimitX96: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    tickBitmap(
      wordPosition: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      0: BigNumber;
    }>;

    "tickBitmap(int16)"(
      wordPosition: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      0: BigNumber;
    }>;

    tickSpacing(overrides?: CallOverrides): Promise<{
      0: number;
    }>;

    "tickSpacing()"(overrides?: CallOverrides): Promise<{
      0: number;
    }>;

    ticks(
      tick: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      liquidityGross: BigNumber;
      liquidityNet: BigNumber;
      feeGrowthOutside0X128: BigNumber;
      feeGrowthOutside1X128: BigNumber;
      tickCumulativeOutside: BigNumber;
      secondsPerLiquidityOutsideX128: BigNumber;
      secondsOutside: number;
      initialized: boolean;
      0: BigNumber;
      1: BigNumber;
      2: BigNumber;
      3: BigNumber;
      4: BigNumber;
      5: BigNumber;
      6: number;
      7: boolean;
    }>;

    "ticks(int24)"(
      tick: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      liquidityGross: BigNumber;
      liquidityNet: BigNumber;
      feeGrowthOutside0X128: BigNumber;
      feeGrowthOutside1X128: BigNumber;
      tickCumulativeOutside: BigNumber;
      secondsPerLiquidityOutsideX128: BigNumber;
      secondsOutside: number;
      initialized: boolean;
      0: BigNumber;
      1: BigNumber;
      2: BigNumber;
      3: BigNumber;
      4: BigNumber;
      5: BigNumber;
      6: number;
      7: boolean;
    }>;

    token0(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "token0()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    token1(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "token1()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;
  };

  burn(
    tickLower: BigNumberish,
    tickUpper: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "burn(int24,int24,uint128)"(
    tickLower: BigNumberish,
    tickUpper: BigNumberish,
    amount: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  collect(
    recipient: string,
    tickLower: BigNumberish,
    tickUpper: BigNumberish,
    amount0Requested: BigNumberish,
    amount1Requested: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "collect(address,int24,int24,uint128,uint128)"(
    recipient: string,
    tickLower: BigNumberish,
    tickUpper: BigNumberish,
    amount0Requested: BigNumberish,
    amount1Requested: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  collectProtocol(
    recipient: string,
    amount0Requested: BigNumberish,
    amount1Requested: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "collectProtocol(address,uint128,uint128)"(
    recipient: string,
    amount0Requested: BigNumberish,
    amount1Requested: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  factory(overrides?: CallOverrides): Promise<string>;

  "factory()"(overrides?: CallOverrides): Promise<string>;

  fee(overrides?: CallOverrides): Promise<number>;

  "fee()"(overrides?: CallOverrides): Promise<number>;

  feeGrowthGlobal0X128(overrides?: CallOverrides): Promise<BigNumber>;

  "feeGrowthGlobal0X128()"(overrides?: CallOverrides): Promise<BigNumber>;

  feeGrowthGlobal1X128(overrides?: CallOverrides): Promise<BigNumber>;

  "feeGrowthGlobal1X128()"(overrides?: CallOverrides): Promise<BigNumber>;

  flash(
    recipient: string,
    amount0: BigNumberish,
    amount1: BigNumberish,
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "flash(address,uint256,uint256,bytes)"(
    recipient: string,
    amount0: BigNumberish,
    amount1: BigNumberish,
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  increaseObservationCardinalityNext(
    observationCardinalityNext: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "increaseObservationCardinalityNext(uint16)"(
    observationCardinalityNext: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  initialize(
    sqrtPriceX96: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "initialize(uint160)"(
    sqrtPriceX96: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  liquidity(overrides?: CallOverrides): Promise<BigNumber>;

  "liquidity()"(overrides?: CallOverrides): Promise<BigNumber>;

  maxLiquidityPerTick(overrides?: CallOverrides): Promise<BigNumber>;

  "maxLiquidityPerTick()"(overrides?: CallOverrides): Promise<BigNumber>;

  mint(
    recipient: string,
    tickLower: BigNumberish,
    tickUpper: BigNumberish,
    amount: BigNumberish,
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "mint(address,int24,int24,uint128,bytes)"(
    recipient: string,
    tickLower: BigNumberish,
    tickUpper: BigNumberish,
    amount: BigNumberish,
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  observations(
    index: BigNumberish,
    overrides?: CallOverrides
  ): Promise<{
    blockTimestamp: number;
    tickCumulative: BigNumber;
    secondsPerLiquidityCumulativeX128: BigNumber;
    initialized: boolean;
    0: number;
    1: BigNumber;
    2: BigNumber;
    3: boolean;
  }>;

  "observations(uint256)"(
    index: BigNumberish,
    overrides?: CallOverrides
  ): Promise<{
    blockTimestamp: number;
    tickCumulative: BigNumber;
    secondsPerLiquidityCumulativeX128: BigNumber;
    initialized: boolean;
    0: number;
    1: BigNumber;
    2: BigNumber;
    3: boolean;
  }>;

  observe(
    secondsAgos: BigNumberish[],
    overrides?: CallOverrides
  ): Promise<{
    tickCumulatives: BigNumber[];
    secondsPerLiquidityCumulativeX128s: BigNumber[];
    0: BigNumber[];
    1: BigNumber[];
  }>;

  "observe(uint32[])"(
    secondsAgos: BigNumberish[],
    overrides?: CallOverrides
  ): Promise<{
    tickCumulatives: BigNumber[];
    secondsPerLiquidityCumulativeX128s: BigNumber[];
    0: BigNumber[];
    1: BigNumber[];
  }>;

  positions(
    key: BytesLike,
    overrides?: CallOverrides
  ): Promise<{
    _liquidity: BigNumber;
    feeGrowthInside0LastX128: BigNumber;
    feeGrowthInside1LastX128: BigNumber;
    tokensOwed0: BigNumber;
    tokensOwed1: BigNumber;
    0: BigNumber;
    1: BigNumber;
    2: BigNumber;
    3: BigNumber;
    4: BigNumber;
  }>;

  "positions(bytes32)"(
    key: BytesLike,
    overrides?: CallOverrides
  ): Promise<{
    _liquidity: BigNumber;
    feeGrowthInside0LastX128: BigNumber;
    feeGrowthInside1LastX128: BigNumber;
    tokensOwed0: BigNumber;
    tokensOwed1: BigNumber;
    0: BigNumber;
    1: BigNumber;
    2: BigNumber;
    3: BigNumber;
    4: BigNumber;
  }>;

  protocolFees(overrides?: CallOverrides): Promise<{
    token0: BigNumber;
    token1: BigNumber;
    0: BigNumber;
    1: BigNumber;
  }>;

  "protocolFees()"(overrides?: CallOverrides): Promise<{
    token0: BigNumber;
    token1: BigNumber;
    0: BigNumber;
    1: BigNumber;
  }>;

  setFeeProtocol(
    feeProtocol0: BigNumberish,
    feeProtocol1: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "setFeeProtocol(uint8,uint8)"(
    feeProtocol0: BigNumberish,
    feeProtocol1: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  slot0(overrides?: CallOverrides): Promise<{
    sqrtPriceX96: BigNumber;
    tick: number;
    observationIndex: number;
    observationCardinality: number;
    observationCardinalityNext: number;
    feeProtocol: number;
    unlocked: boolean;
    0: BigNumber;
    1: number;
    2: number;
    3: number;
    4: number;
    5: number;
    6: boolean;
  }>;

  "slot0()"(overrides?: CallOverrides): Promise<{
    sqrtPriceX96: BigNumber;
    tick: number;
    observationIndex: number;
    observationCardinality: number;
    observationCardinalityNext: number;
    feeProtocol: number;
    unlocked: boolean;
    0: BigNumber;
    1: number;
    2: number;
    3: number;
    4: number;
    5: number;
    6: boolean;
  }>;

  snapshotCumulativesInside(
    tickLower: BigNumberish,
    tickUpper: BigNumberish,
    overrides?: CallOverrides
  ): Promise<{
    tickCumulativeInside: BigNumber;
    secondsPerLiquidityInsideX128: BigNumber;
    secondsInside: number;
    0: BigNumber;
    1: BigNumber;
    2: number;
  }>;

  "snapshotCumulativesInside(int24,int24)"(
    tickLower: BigNumberish,
    tickUpper: BigNumberish,
    overrides?: CallOverrides
  ): Promise<{
    tickCumulativeInside: BigNumber;
    secondsPerLiquidityInsideX128: BigNumber;
    secondsInside: number;
    0: BigNumber;
    1: BigNumber;
    2: number;
  }>;

  swap(
    recipient: string,
    zeroForOne: boolean,
    amountSpecified: BigNumberish,
    sqrtPriceLimitX96: BigNumberish,
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "swap(address,bool,int256,uint160,bytes)"(
    recipient: string,
    zeroForOne: boolean,
    amountSpecified: BigNumberish,
    sqrtPriceLimitX96: BigNumberish,
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  tickBitmap(
    wordPosition: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  "tickBitmap(int16)"(
    wordPosition: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  tickSpacing(overrides?: CallOverrides): Promise<number>;

  "tickSpacing()"(overrides?: CallOverrides): Promise<number>;

  ticks(
    tick: BigNumberish,
    overrides?: CallOverrides
  ): Promise<{
    liquidityGross: BigNumber;
    liquidityNet: BigNumber;
    feeGrowthOutside0X128: BigNumber;
    feeGrowthOutside1X128: BigNumber;
    tickCumulativeOutside: BigNumber;
    secondsPerLiquidityOutsideX128: BigNumber;
    secondsOutside: number;
    initialized: boolean;
    0: BigNumber;
    1: BigNumber;
    2: BigNumber;
    3: BigNumber;
    4: BigNumber;
    5: BigNumber;
    6: number;
    7: boolean;
  }>;

  "ticks(int24)"(
    tick: BigNumberish,
    overrides?: CallOverrides
  ): Promise<{
    liquidityGross: BigNumber;
    liquidityNet: BigNumber;
    feeGrowthOutside0X128: BigNumber;
    feeGrowthOutside1X128: BigNumber;
    tickCumulativeOutside: BigNumber;
    secondsPerLiquidityOutsideX128: BigNumber;
    secondsOutside: number;
    initialized: boolean;
    0: BigNumber;
    1: BigNumber;
    2: BigNumber;
    3: BigNumber;
    4: BigNumber;
    5: BigNumber;
    6: number;
    7: boolean;
  }>;

  token0(overrides?: CallOverrides): Promise<string>;

  "token0()"(overrides?: CallOverrides): Promise<string>;

  token1(overrides?: CallOverrides): Promise<string>;

  "token1()"(overrides?: CallOverrides): Promise<string>;

  callStatic: {
    burn(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    "burn(int24,int24,uint128)"(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    collect(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    "collect(address,int24,int24,uint128,uint128)"(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    collectProtocol(
      recipient: string,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    "collectProtocol(address,uint128,uint128)"(
      recipient: string,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    factory(overrides?: CallOverrides): Promise<string>;

    "factory()"(overrides?: CallOverrides): Promise<string>;

    fee(overrides?: CallOverrides): Promise<number>;

    "fee()"(overrides?: CallOverrides): Promise<number>;

    feeGrowthGlobal0X128(overrides?: CallOverrides): Promise<BigNumber>;

    "feeGrowthGlobal0X128()"(overrides?: CallOverrides): Promise<BigNumber>;

    feeGrowthGlobal1X128(overrides?: CallOverrides): Promise<BigNumber>;

    "feeGrowthGlobal1X128()"(overrides?: CallOverrides): Promise<BigNumber>;

    flash(
      recipient: string,
      amount0: BigNumberish,
      amount1: BigNumberish,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<void>;

    "flash(address,uint256,uint256,bytes)"(
      recipient: string,
      amount0: BigNumberish,
      amount1: BigNumberish,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<void>;

    increaseObservationCardinalityNext(
      observationCardinalityNext: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "increaseObservationCardinalityNext(uint16)"(
      observationCardinalityNext: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    initialize(
      sqrtPriceX96: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "initialize(uint160)"(
      sqrtPriceX96: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    liquidity(overrides?: CallOverrides): Promise<BigNumber>;

    "liquidity()"(overrides?: CallOverrides): Promise<BigNumber>;

    maxLiquidityPerTick(overrides?: CallOverrides): Promise<BigNumber>;

    "maxLiquidityPerTick()"(overrides?: CallOverrides): Promise<BigNumber>;

    mint(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    "mint(address,int24,int24,uint128,bytes)"(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    observations(
      index: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      blockTimestamp: number;
      tickCumulative: BigNumber;
      secondsPerLiquidityCumulativeX128: BigNumber;
      initialized: boolean;
      0: number;
      1: BigNumber;
      2: BigNumber;
      3: boolean;
    }>;

    "observations(uint256)"(
      index: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      blockTimestamp: number;
      tickCumulative: BigNumber;
      secondsPerLiquidityCumulativeX128: BigNumber;
      initialized: boolean;
      0: number;
      1: BigNumber;
      2: BigNumber;
      3: boolean;
    }>;

    observe(
      secondsAgos: BigNumberish[],
      overrides?: CallOverrides
    ): Promise<{
      tickCumulatives: BigNumber[];
      secondsPerLiquidityCumulativeX128s: BigNumber[];
      0: BigNumber[];
      1: BigNumber[];
    }>;

    "observe(uint32[])"(
      secondsAgos: BigNumberish[],
      overrides?: CallOverrides
    ): Promise<{
      tickCumulatives: BigNumber[];
      secondsPerLiquidityCumulativeX128s: BigNumber[];
      0: BigNumber[];
      1: BigNumber[];
    }>;

    positions(
      key: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      _liquidity: BigNumber;
      feeGrowthInside0LastX128: BigNumber;
      feeGrowthInside1LastX128: BigNumber;
      tokensOwed0: BigNumber;
      tokensOwed1: BigNumber;
      0: BigNumber;
      1: BigNumber;
      2: BigNumber;
      3: BigNumber;
      4: BigNumber;
    }>;

    "positions(bytes32)"(
      key: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      _liquidity: BigNumber;
      feeGrowthInside0LastX128: BigNumber;
      feeGrowthInside1LastX128: BigNumber;
      tokensOwed0: BigNumber;
      tokensOwed1: BigNumber;
      0: BigNumber;
      1: BigNumber;
      2: BigNumber;
      3: BigNumber;
      4: BigNumber;
    }>;

    protocolFees(overrides?: CallOverrides): Promise<{
      token0: BigNumber;
      token1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    "protocolFees()"(overrides?: CallOverrides): Promise<{
      token0: BigNumber;
      token1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    setFeeProtocol(
      feeProtocol0: BigNumberish,
      feeProtocol1: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "setFeeProtocol(uint8,uint8)"(
      feeProtocol0: BigNumberish,
      feeProtocol1: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    slot0(overrides?: CallOverrides): Promise<{
      sqrtPriceX96: BigNumber;
      tick: number;
      observationIndex: number;
      observationCardinality: number;
      observationCardinalityNext: number;
      feeProtocol: number;
      unlocked: boolean;
      0: BigNumber;
      1: number;
      2: number;
      3: number;
      4: number;
      5: number;
      6: boolean;
    }>;

    "slot0()"(overrides?: CallOverrides): Promise<{
      sqrtPriceX96: BigNumber;
      tick: number;
      observationIndex: number;
      observationCardinality: number;
      observationCardinalityNext: number;
      feeProtocol: number;
      unlocked: boolean;
      0: BigNumber;
      1: number;
      2: number;
      3: number;
      4: number;
      5: number;
      6: boolean;
    }>;

    snapshotCumulativesInside(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      tickCumulativeInside: BigNumber;
      secondsPerLiquidityInsideX128: BigNumber;
      secondsInside: number;
      0: BigNumber;
      1: BigNumber;
      2: number;
    }>;

    "snapshotCumulativesInside(int24,int24)"(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      tickCumulativeInside: BigNumber;
      secondsPerLiquidityInsideX128: BigNumber;
      secondsInside: number;
      0: BigNumber;
      1: BigNumber;
      2: number;
    }>;

    swap(
      recipient: string,
      zeroForOne: boolean,
      amountSpecified: BigNumberish,
      sqrtPriceLimitX96: BigNumberish,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    "swap(address,bool,int256,uint160,bytes)"(
      recipient: string,
      zeroForOne: boolean,
      amountSpecified: BigNumberish,
      sqrtPriceLimitX96: BigNumberish,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      amount0: BigNumber;
      amount1: BigNumber;
      0: BigNumber;
      1: BigNumber;
    }>;

    tickBitmap(
      wordPosition: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "tickBitmap(int16)"(
      wordPosition: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    tickSpacing(overrides?: CallOverrides): Promise<number>;

    "tickSpacing()"(overrides?: CallOverrides): Promise<number>;

    ticks(
      tick: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      liquidityGross: BigNumber;
      liquidityNet: BigNumber;
      feeGrowthOutside0X128: BigNumber;
      feeGrowthOutside1X128: BigNumber;
      tickCumulativeOutside: BigNumber;
      secondsPerLiquidityOutsideX128: BigNumber;
      secondsOutside: number;
      initialized: boolean;
      0: BigNumber;
      1: BigNumber;
      2: BigNumber;
      3: BigNumber;
      4: BigNumber;
      5: BigNumber;
      6: number;
      7: boolean;
    }>;

    "ticks(int24)"(
      tick: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      liquidityGross: BigNumber;
      liquidityNet: BigNumber;
      feeGrowthOutside0X128: BigNumber;
      feeGrowthOutside1X128: BigNumber;
      tickCumulativeOutside: BigNumber;
      secondsPerLiquidityOutsideX128: BigNumber;
      secondsOutside: number;
      initialized: boolean;
      0: BigNumber;
      1: BigNumber;
      2: BigNumber;
      3: BigNumber;
      4: BigNumber;
      5: BigNumber;
      6: number;
      7: boolean;
    }>;

    token0(overrides?: CallOverrides): Promise<string>;

    "token0()"(overrides?: CallOverrides): Promise<string>;

    token1(overrides?: CallOverrides): Promise<string>;

    "token1()"(overrides?: CallOverrides): Promise<string>;
  };

  filters: {
    Burn(
      owner: string | null,
      tickLower: BigNumberish | null,
      tickUpper: BigNumberish | null,
      amount: null,
      amount0: null,
      amount1: null
    ): EventFilter;

    Collect(
      owner: string | null,
      recipient: null,
      tickLower: BigNumberish | null,
      tickUpper: BigNumberish | null,
      amount0: null,
      amount1: null
    ): EventFilter;

    CollectProtocol(
      sender: string | null,
      recipient: string | null,
      amount0: null,
      amount1: null
    ): EventFilter;

    Flash(
      sender: string | null,
      recipient: string | null,
      amount0: null,
      amount1: null,
      paid0: null,
      paid1: null
    ): EventFilter;

    IncreaseObservationCardinalityNext(
      observationCardinalityNextOld: null,
      observationCardinalityNextNew: null
    ): EventFilter;

    Initialize(sqrtPriceX96: null, tick: null): EventFilter;

    Mint(
      sender: null,
      owner: string | null,
      tickLower: BigNumberish | null,
      tickUpper: BigNumberish | null,
      amount: null,
      amount0: null,
      amount1: null
    ): EventFilter;

    SetFeeProtocol(
      feeProtocol0Old: null,
      feeProtocol1Old: null,
      feeProtocol0New: null,
      feeProtocol1New: null
    ): EventFilter;

    Swap(
      sender: string | null,
      recipient: string | null,
      amount0: null,
      amount1: null,
      sqrtPriceX96: null,
      liquidity: null,
      tick: null
    ): EventFilter;
  };

  estimateGas: {
    burn(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "burn(int24,int24,uint128)"(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    collect(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "collect(address,int24,int24,uint128,uint128)"(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    collectProtocol(
      recipient: string,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "collectProtocol(address,uint128,uint128)"(
      recipient: string,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    factory(overrides?: CallOverrides): Promise<BigNumber>;

    "factory()"(overrides?: CallOverrides): Promise<BigNumber>;

    fee(overrides?: CallOverrides): Promise<BigNumber>;

    "fee()"(overrides?: CallOverrides): Promise<BigNumber>;

    feeGrowthGlobal0X128(overrides?: CallOverrides): Promise<BigNumber>;

    "feeGrowthGlobal0X128()"(overrides?: CallOverrides): Promise<BigNumber>;

    feeGrowthGlobal1X128(overrides?: CallOverrides): Promise<BigNumber>;

    "feeGrowthGlobal1X128()"(overrides?: CallOverrides): Promise<BigNumber>;

    flash(
      recipient: string,
      amount0: BigNumberish,
      amount1: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "flash(address,uint256,uint256,bytes)"(
      recipient: string,
      amount0: BigNumberish,
      amount1: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    increaseObservationCardinalityNext(
      observationCardinalityNext: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "increaseObservationCardinalityNext(uint16)"(
      observationCardinalityNext: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    initialize(
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "initialize(uint160)"(
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    liquidity(overrides?: CallOverrides): Promise<BigNumber>;

    "liquidity()"(overrides?: CallOverrides): Promise<BigNumber>;

    maxLiquidityPerTick(overrides?: CallOverrides): Promise<BigNumber>;

    "maxLiquidityPerTick()"(overrides?: CallOverrides): Promise<BigNumber>;

    mint(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "mint(address,int24,int24,uint128,bytes)"(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    observations(
      index: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "observations(uint256)"(
      index: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    observe(
      secondsAgos: BigNumberish[],
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "observe(uint32[])"(
      secondsAgos: BigNumberish[],
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    positions(key: BytesLike, overrides?: CallOverrides): Promise<BigNumber>;

    "positions(bytes32)"(
      key: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    protocolFees(overrides?: CallOverrides): Promise<BigNumber>;

    "protocolFees()"(overrides?: CallOverrides): Promise<BigNumber>;

    setFeeProtocol(
      feeProtocol0: BigNumberish,
      feeProtocol1: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "setFeeProtocol(uint8,uint8)"(
      feeProtocol0: BigNumberish,
      feeProtocol1: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    slot0(overrides?: CallOverrides): Promise<BigNumber>;

    "slot0()"(overrides?: CallOverrides): Promise<BigNumber>;

    snapshotCumulativesInside(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "snapshotCumulativesInside(int24,int24)"(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    swap(
      recipient: string,
      zeroForOne: boolean,
      amountSpecified: BigNumberish,
      sqrtPriceLimitX96: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "swap(address,bool,int256,uint160,bytes)"(
      recipient: string,
      zeroForOne: boolean,
      amountSpecified: BigNumberish,
      sqrtPriceLimitX96: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    tickBitmap(
      wordPosition: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "tickBitmap(int16)"(
      wordPosition: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    tickSpacing(overrides?: CallOverrides): Promise<BigNumber>;

    "tickSpacing()"(overrides?: CallOverrides): Promise<BigNumber>;

    ticks(tick: BigNumberish, overrides?: CallOverrides): Promise<BigNumber>;

    "ticks(int24)"(
      tick: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    token0(overrides?: CallOverrides): Promise<BigNumber>;

    "token0()"(overrides?: CallOverrides): Promise<BigNumber>;

    token1(overrides?: CallOverrides): Promise<BigNumber>;

    "token1()"(overrides?: CallOverrides): Promise<BigNumber>;
  };

  populateTransaction: {
    burn(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "burn(int24,int24,uint128)"(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    collect(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "collect(address,int24,int24,uint128,uint128)"(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    collectProtocol(
      recipient: string,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "collectProtocol(address,uint128,uint128)"(
      recipient: string,
      amount0Requested: BigNumberish,
      amount1Requested: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    factory(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "factory()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    fee(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "fee()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    feeGrowthGlobal0X128(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "feeGrowthGlobal0X128()"(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    feeGrowthGlobal1X128(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "feeGrowthGlobal1X128()"(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    flash(
      recipient: string,
      amount0: BigNumberish,
      amount1: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "flash(address,uint256,uint256,bytes)"(
      recipient: string,
      amount0: BigNumberish,
      amount1: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    increaseObservationCardinalityNext(
      observationCardinalityNext: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "increaseObservationCardinalityNext(uint16)"(
      observationCardinalityNext: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    initialize(
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "initialize(uint160)"(
      sqrtPriceX96: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    liquidity(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "liquidity()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    maxLiquidityPerTick(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "maxLiquidityPerTick()"(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    mint(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "mint(address,int24,int24,uint128,bytes)"(
      recipient: string,
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      amount: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    observations(
      index: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "observations(uint256)"(
      index: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    observe(
      secondsAgos: BigNumberish[],
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "observe(uint32[])"(
      secondsAgos: BigNumberish[],
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    positions(
      key: BytesLike,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "positions(bytes32)"(
      key: BytesLike,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    protocolFees(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "protocolFees()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    setFeeProtocol(
      feeProtocol0: BigNumberish,
      feeProtocol1: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "setFeeProtocol(uint8,uint8)"(
      feeProtocol0: BigNumberish,
      feeProtocol1: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    slot0(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "slot0()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    snapshotCumulativesInside(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "snapshotCumulativesInside(int24,int24)"(
      tickLower: BigNumberish,
      tickUpper: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    swap(
      recipient: string,
      zeroForOne: boolean,
      amountSpecified: BigNumberish,
      sqrtPriceLimitX96: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "swap(address,bool,int256,uint160,bytes)"(
      recipient: string,
      zeroForOne: boolean,
      amountSpecified: BigNumberish,
      sqrtPriceLimitX96: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    tickBitmap(
      wordPosition: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "tickBitmap(int16)"(
      wordPosition: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    tickSpacing(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "tickSpacing()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    ticks(
      tick: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "ticks(int24)"(
      tick: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    token0(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "token0()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    token1(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "token1()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;
  };
}
